/*** este codigo permite testear el mecanismo de obtención de descriptores ***/
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <usb.h>
//#include <sys/ioctl.h>
#include <errno.h>
#include <stdint.h>
#include <stdlib.h>

#define GET_DEVICE_DESCRIPTOR   0x0001
#define SET_DESC_INDEX          0x0002
#define GET_ENDPOINT_DESCRIPTOR  0x0005
#define GET_INTERFACE_DESCRIPTOR 0x0006
#define GET_CONFIGURATION_DESCRIPTOR 0x0007
#define GET_STRING_DESCRIPTOR           0x000a
#define DEBUG_STRING_DESCRIPTOR         0x000b

main(int argc, char **argv){
int fd, io;
struct usb_device_descriptor descriptor;
struct usb_interface_descriptor idescriptor;
struct usb_endpoint_descriptor edescriptor;
struct usb_config_descriptor cdescriptor;
struct usb_string_descriptor sdescriptor;

char string[255];
char string2[255];
int var = 3, numEndpoints, i = 0;
fd  = open("/dev/usb4all0", O_RDWR);
printf("el fd vale%d\n", fd);
io = ioctl(fd, SET_DESC_INDEX, &i);
printf("pase 1\n");
io = ioctl(fd, GET_DEVICE_DESCRIPTOR, (&descriptor));
printf("el io vale%d\n", io);

printf("El bLength vale:%p\n", (uint8_t)descriptor.bLength);
printf("El bDescriptorType vale:%p\n", (uint8_t)descriptor.bDescriptorType);
printf("El bcdUSB vale:%p\n", (uint16_t)descriptor.bcdUSB);
printf("El bDeviceClass vale:%p\n", (uint8_t)descriptor.bDeviceClass);
printf("El bDeviceSubClass vale:%p\n", (uint8_t)descriptor.bDeviceSubClass);
printf("El bDeviceProtocol vale:%p\n", (uint8_t)descriptor.bDeviceProtocol);
printf("El bMaxPacketSize0 vale:%p\n", (uint8_t)descriptor.bMaxPacketSize0);
printf("El bcdDevice vale:%p\n", (uint16_t)descriptor.bcdDevice);
printf("El iManufacturer vale:%p\n", (uint8_t)descriptor.iManufacturer);
printf("El iProduct vale:%p\n", (uint8_t)descriptor.iProduct);
printf("El iSerialNumber vale:%p\n", (uint8_t)descriptor.iSerialNumber);
printf("El bNumConfigurations vale:%p\n", (uint8_t)descriptor.bNumConfigurations);
printf("El idVendor vale:%p\n", (uint16_t)descriptor.idVendor);
printf("El idProduct vale:%p\n", (uint16_t)descriptor.idProduct);
io = ioctl(fd, GET_CONFIGURATION_DESCRIPTOR, (&cdescriptor));
printf("getConfiguration devuelve:%d\n", io);
printf("El bLength vale:%p\n", (uint8_t)cdescriptor.bLength);
printf("El bDescriptorType vale:%p\n", (uint8_t)cdescriptor.bDescriptorType);
printf("El wTotalLength vale:%p\n", (uint16_t)cdescriptor.wTotalLength);
printf("El bNumInterfaces vale:%p\n", (uint8_t)cdescriptor.bNumInterfaces);
printf("El bConfigurationValue vale:%p\n", (uint8_t)cdescriptor.bConfigurationValue);
printf("El iConfiguration vale:%p\n", (uint8_t)cdescriptor.iConfiguration);
printf("El bmAttributes vale:%p\n", (uint8_t)cdescriptor.bmAttributes);
printf("El MaxPower vale:%p\n", (uint8_t)cdescriptor.MaxPower);

i=0;
io = ioctl(fd, SET_DESC_INDEX, (&i));
printf("setDesc devuelve:%d\n", io);
io = ioctl(fd, GET_INTERFACE_DESCRIPTOR, (&idescriptor));
fprintf(stderr,"%s: ioctl(stdin, TIOCLINUX): %s\n",
                argv[0], strerror(errno));
printf("getinterface devuelve:%d\n", io);
printf("El numero de endpoints es: %p\n", (uint8_t)idescriptor.bNumEndpoints);
numEndpoints = (int)idescriptor.bNumEndpoints;
for (i=0;i<numEndpoints;i++){
	ioctl(fd, SET_DESC_INDEX, (&i));
	ioctl(fd, GET_ENDPOINT_DESCRIPTOR, (&edescriptor));
	printf("El address del endpoint es: %p\n", (uint8_t)edescriptor.bEndpointAddress);	
}

        fprintf(stderr,"%s: ioctl(stdin, TIOCLINUX): %s\n",
                argv[0], strerror(errno));
i = descriptor.iManufacturer;
io = ioctl(fd, SET_DESC_INDEX, (&i));
io = ioctl(fd, GET_STRING_DESCRIPTOR, (&sdescriptor));
printf("El bLength vale:%p\n", (uint8_t)sdescriptor.bLength);
printf("El bDescriptorType vale:%p\n", (uint8_t)sdescriptor.bDescriptorType);
//io = wcstombs ((char*)string, (const wchar_t *)&(sdescriptor.wData[0]), sdescriptor.bLength - 2); 
io = ioctl(fd, DEBUG_STRING_DESCRIPTOR, (char*)string);
printf("manufaturer is: %s\n", string);
i = descriptor.iSerialNumber;
io = ioctl(fd, SET_DESC_INDEX, (&i));
io = ioctl(fd, DEBUG_STRING_DESCRIPTOR, (char*)string2);
printf("serie is: %s\n", string2);

i = descriptor.iProduct;
io = ioctl(fd, SET_DESC_INDEX, (&i));
io = ioctl(fd, DEBUG_STRING_DESCRIPTOR, (char*)string2);
printf("serie is: %s\n", string2);

close(fd);
}


